/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.common.util.Trace;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbemcfg.GlobalConfig;

public class VersionComparator {
    public static Hashtable HMC_CSP_VersionTable = new Hashtable();
    private static boolean isInitialized = true;
    private static final int VERSION_COMPARATOR_DEBUG = 7;
    public static Vector cspVersion = new Vector();
    public static final int[] cspVersionArr = new int[]{1000, 2000, 3000, 4000};

    public static int CSPVersionValue(String string) throws HSCCIMException {
        int n = -1;
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("VersionComparator - CSPVersionValue");
            System.out.println("CSPVersionValue - input version = " + string);
        }
        Trace.trace("averhscT", "-> CSPVersionValue");
        Trace.trace("averhscF", "version = " + string);
        int n2 = cspVersion.indexOf(string);
        if (n2 >= 0) {
            return cspVersionArr[n2];
        }
        Trace.trace("averhscF", "returnVal = " + n);
        Trace.trace("averhscT", "<- CSPVersionValue");
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("CSPVersionValue - returned returnVal = " + n);
            System.out.print("********************************");
            System.out.println("********************************");
        }
        return -1;
    }

    public static boolean isCompatible(String string, String string2) throws HSCCIMException {
        boolean bl = false;
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("VersionComparator - isCompatible");
            System.out.println("isCompatible - input HMCVersion = " + string);
            System.out.println("isCompatible - input CSPVersion = " + string2);
        }
        Trace.trace("averhscT", "-> isCompatible");
        Trace.trace("averhscF", "HMCVersion = " + string);
        Trace.trace("averhscF", "CSPVersion = " + string2);
        if (!isInitialized) {
            Trace.trace("averhscT", "<- isCompatible");
            throw new HSCCIMException("1396");
        }
        CSPVersionRange[] cSPVersionRangeArray = (CSPVersionRange[])HMC_CSP_VersionTable.get(string);
        if (cSPVersionRangeArray == null) {
            Trace.trace("averhscT", "<- isCompatible");
            throw new HSCCIMException("1398");
        }
        int n = 0;
        while (n < cSPVersionRangeArray.length && !bl) {
            bl = cSPVersionRangeArray[n].isBetween(VersionComparator.CSPVersionValue(string2));
            ++n;
        }
        Trace.trace("averhscF", "compatibleVersions = " + bl);
        Trace.trace("averhscT", "<- isCompatible");
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("isCompatible - returned compatibleVersions = " + bl);
            System.out.print("********************************");
            System.out.println("********************************");
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        block3: {
            String string = "R1V1.2";
            String string2 = "V1.0";
            try {
                if (VersionComparator.isCompatible(string, string2)) {
                    System.out.println("This HMC is compatible with this CSP");
                    break block3;
                }
                System.out.println("This HMC is NOT compatible with this CSP");
            }
            catch (HSCCIMException hSCCIMException) {
                hSCCIMException.printStackTrace();
            }
        }
    }

    static {
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("VersionComparator - static block");
        }
        Trace.trace("averhscT", "-> static block");
        try {
            cspVersion.addElement("V1.0");
            cspVersion.addElement("V2.0");
            cspVersion.addElement("V3.0");
            cspVersion.addElement("V4.0");
            HMC_CSP_VersionTable.put("R1V1.2", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V1.0")});
            HMC_CSP_VersionTable.put("R2V1.0", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V2.0")});
            HMC_CSP_VersionTable.put("R2V1.1", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V2.0")});
            HMC_CSP_VersionTable.put("R2V1.2", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V2.0")});
            HMC_CSP_VersionTable.put("R3V1.0", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V3.0")});
            HMC_CSP_VersionTable.put("R3V1.1", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V3.0")});
            HMC_CSP_VersionTable.put("R3V1.2", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V3.0")});
            HMC_CSP_VersionTable.put("R3V2.0", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("R3V2.1", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("R3V2.2", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("R3V2.3", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("R3V2.4", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("R3V2.5", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("R3V2.6", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("V3R3.0", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("V3R3.1", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            HMC_CSP_VersionTable.put("V3R3.2", new CSPVersionRange[]{new CSPVersionRange("V1.0", "V4.0")});
            isInitialized = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            isInitialized = false;
        }
        Trace.trace("averhscF", "isInitialized = " + isInitialized);
        Trace.trace("averhscT", "<- static block");
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("static block - isInitialized = " + isInitialized);
            System.out.print("********************************");
            System.out.println("********************************");
        }
    }

    public static class CSPVersionRange {
        private int minVersion = -1;
        private int maxVersion = -1;

        public CSPVersionRange(String string, String string2) throws HSCCIMException {
            this.minVersion = VersionComparator.CSPVersionValue(string);
            this.maxVersion = VersionComparator.CSPVersionValue(string2);
        }

        public boolean isBetween(int n) {
            return this.minVersion <= n && n <= this.maxVersion;
        }
    }
}

